;================================================

;================================================
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl" 
begin
;************************************************
; open file and read in data
;************************************************

;*************************
  geof1  = addfile("/home/user/chensy3/data/zhangyue/WPSV391_2020-03/geo_em.d01.nc","r")
  lat1_sim   = geof1->XLAT_M
  lon1_sim   = geof1->XLONG_M
  lat=lat1_sim(0,:,:)
  lon=lon1_sim(0,:,:)

  nday=6
  plot=new(nday,graphic)
  plot_t=new(nday,graphic)
  vector=new(nday,graphic)


;************************************************
wks = gsn_open_wks("png","poumian1")     ; open a workstation

gsn_define_colormap(wks,"BlueDarkRed18")

;========================================


path=" /home/user/chensy3/csr4/zhangyue/wrfdata/wrfout/ETL_data/CON_UVW_Z/2020-03/"

filename="wrfout_dustconcentration_UVW_2020_03_1*.nc"
outfiles=systemfunc("ls " +path+filename)
f=addfiles(outfiles+".nc","r")

ListSetType(f,"join")
con = wrf_user_getvar(f(:),"DC",-1)

;printVarSummary(con)
;do i = 0,5
;printMinMax(con(i,:,:,:),False)
;end do

u = wrf_user_getvar(f(:),"u",-1)
v = wrf_user_getvar(f(:),"v",-1)
w = wrf_user_getvar(f(:),"w",-1)

z  = f[:]->z
;:::::::::::::::::::::::::::::::::::::::::::::


  lat2=40
  lon2=100
  loc = wrf_user_ll_to_ij(geof1,lon2,lat2,False)

  plane  = (/loc(0),loc(1)/)
  angle = 90
 
  opts       = False 

  zmin = 0.
  zmax = max(z(0,:,:,:))/1000.
  
  
;::::::::::::::::::::::::::::::::::::::::


  u_planes     = wrf_user_intrp3d(u,z,"v",plane,angle,opts)*1.
  v_planes     = wrf_user_intrp3d(v,z,"v",plane,angle,opts)
  w_planes     = wrf_user_intrp3d(w,z,"v",plane,angle,opts)*1.
  con_planes   = wrf_user_intrp3d(con,z,"v",plane,angle,opts)*1.
  printVarSummary(con_planes)
  delete(con_planes@_FillVaule)
  printMinMax(con_planes,False)


;=====================================================
  resb=True
  resb@gsnDraw               = False
  resb@gsnFrame              = False
  resb@cnInfoLabelOn         = False
  resb@cnLineLabelsOn        = False
  resb@cnLevelSelectionMode ="ExplicitLevels"
  resb@cnLevels=(/1,10,50,100,200,300,400,500/)
  resb@cnFillColors = (/0,11,12,13,14,15,16,17,18,19/)
  resb@cnFillOn              = True
  resb@cnLinesOn             = False
  resb@tmXBLabelFont          = 21
  resb@tmXBLabelFontHeightF   = 0.03
  resb@tmYLLabelFont          = 21
  resb@tmYLLabelFontHeightF   = 0.03
  resb@tiYAxisFont            = 21
  resb@tiYAxisFontHeightF     = 0.03
  resb@tiXAxisFont            = 21
  resb@tiXAxisFontHeightF     = 0.03

  dim = dimsizes(u_planes(0,:,:))
  resb@tmYLMode   = "Explicit"  ; explicitly set the Y-axis labels
  resb@tmYLValues = fspan(0,dim(0)-1,8)
  resb@tmYLLabels      = sprintf("%.1f",fspan(0,max(z)/1000.,8))
  resb@tmXBMode ="Explicit"
  resb@tmXBValues=fspan(0,dim(1)-1,4)
  min_lon= min(lon(loc(1)-1,:))  
  max_lon= max(lon(loc(1)-1,:))  
  ;print(fspan(min_lon,max_lon,6))
  resb@tmXBLabels   = sprintf("%.1f",fspan(min_lon,max_lon,4))+"E"
  resb@tiYAxisString        = "Height (km)"
  resb@tiXAxisString        ="Lontitude"
  resb@gsnSpreadColors  = True
  resb@tmXTOn=False
  resb@tmYROn=False
  resb@tmXBLabelFontHeightF=0.035
  resb@tmYLLabelFontHeightF=0.035
  resb@tmBorderThicknessF=3
  resb@lbLabelFontHeightF=0.03

  resb@lbLabelBarOn=True
  resb@pmLabelBarWidthF = 0.6
  resb@pmLabelBarHeightF=0.1
  ;resb@lbLabelFontHeightF = 0.01
  ;resb@pmLabelBarOrthogonalPosF=0.1

  resb@cnMissingValPerimOn = True
  resb@cnMissingValPerimColor  = "black"
  resb@cnMissingValFillColor = "black"
  resb@cnMissingValFillPattern = 0
  
  optsb             = True
 ;optsb@InitTime    = False                   ; Do not plot time or footers
  optsb@gsnDraw     = False
  optsb@gsnFrame    = False
  optsb@vcRefMagnitudeF  = 12
  optsb@vcRefLengthF     = 0.03                ; what the ref length is
  optsb@vcWindBarbLineThicknessF=1.5
  optsb@vcWindBarbTickSpacingF=0.2
  optsb@vcWindBarbTickLengthF=0.4
  optsb@vcGlyphStyle="CurlyVector"
  optsb@gsnSpreadColors  = True
 ;optsb@Footer = False
 ;optsb@InitTime    = False
 ;optsb@FieldTitle=""
  optsb@vcLineArrowColor = "black"
  optsb@vcLineArrowThicknessF=2.0
  optsb@vcRefAnnoOn=True
  optsb@vcRefAnnoString1="12m/s"
  optsb@vcRefAnnoOrthogonalPosF =-0.2
  optsb@vcRefAnnoSide ="Top"  ;Bottom;Right;Left
  optsb@vcMinDistanceF=0.03;0.04
  optsb@vcRefAnnoFontHeightF=0.025
  wscale = w_planes(0,:,:)*100. ;*scale

  
  
;=======================================

 
  res=True
  res@gsnDraw               = False
  res@gsnFrame              = False
  res@cnInfoLabelOn         = False
  res@cnLineLabelsOn        = False
  res@cnLevelSelectionMode ="ExplicitLevels"
  res@cnLevels=(/-20,-10,-8,-5,-3,-1,-0.1,0.1,1,3,5,8,10,20/)
  res@cnFillColors = (/2,3,4,5,6,7,8,0,12,13,14,15,16,17,18/)
  res@cnFillOn              = True
  res@cnLinesOn             = False
  res@tmXBLabelFont          = 21
  res@tmXBLabelFontHeightF   = 0.03
  res@tmYLLabelFont          = 21
  res@tmYLLabelFontHeightF   = 0.03
  res@tiYAxisFont            = 21
  res@tiYAxisFontHeightF     = 0.03
  res@tiXAxisFont            = 21
  res@tiXAxisFontHeightF     = 0.03

  dim = dimsizes(u_planes(0,:,:))
  res@tmYLMode   = "Explicit"  ; explicitly set the Y-axis labels
  res@tmYLValues = fspan(0,dim(0)-1,8)
  res@tmYLLabels      = sprintf("%.1f",fspan(0,max(z)/1000.,8))
  res@tmXBMode ="Explicit"
  res@tmXBValues=fspan(0,dim(1)-1,4)
  min_lon= min(lon(loc(1)-1,:))  
  max_lon= max(lon(loc(1)-1,:))  
  ;print(fspan(min_lon,max_lon,6))
  res@tmXBLabels   = sprintf("%.1f",fspan(min_lon,max_lon,4))+"E"
  res@tiYAxisString        = "Height (km)"
  res@tiXAxisString        ="Lontitude"
  res@gsnSpreadColors  = True

  res@lbLabelBarOn=True
  res@pmLabelBarWidthF = 0.6
  res@pmLabelBarHeightF=0.1
  ;res@lbLabelFontHeightF = 0.01
  ;res@pmLabelBarOrthogonalPosF=0.1  

  res@cnMissingValPerimOn = True
  res@cnMissingValPerimColor  = "black"
  res@cnMissingValFillColor = "black"
  res@cnMissingValFillPattern = 0

  res@tmXTOn=False
  res@tmYROn=False
  res@tmXBLabelFontHeightF=0.035
  res@tmYLLabelFontHeightF=0.035
  res@tmBorderThicknessF=3
  res@lbLabelFontHeightF=0.03
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

  opts             = True
 ;opts@InitTime    = False                   ; Do not plot time or footers
  opts@gsnDraw     = False                   
  opts@gsnFrame    = False                   
  opts@vcRefMagnitudeF  = 0.05
  opts@vcRefLengthF     = 0.03                ; what the ref length is
  opts@vcWindBarbLineThicknessF=1.5           
  opts@vcWindBarbTickSpacingF=0.2
  opts@vcWindBarbTickLengthF=0.4
  opts@vcGlyphStyle="CurlyVector"
  opts@gsnSpreadColors  = True   
 ;opts@Footer = False
 ;opts@InitTime    = False
 ;opts@FieldTitle="" 
  opts@vcLineArrowColor = "black"
  opts@vcLineArrowThicknessF=2.0 
  opts@vcRefAnnoOn=True      
  opts@vcRefAnnoString1="0.05m/s"
  opts@vcRefAnnoOrthogonalPosF =-0.2
  opts@vcRefAnnoSide ="Top"  ;Bottom;Right;Left
  opts@vcMinDistanceF=0.03;0.04
  opts@vcRefAnnoFontHeightF=0.025

 

;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   plot_t(0)  = gsn_csm_contour(wks,con_planes(0,:65,:),resb)
   vector(0)  = gsn_csm_vector(wks,u_planes(0,:65,:),wscale(:65,:),optsb)
   overlay(plot_t(0),vector(0))
;:;;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;
   con_planesb=new((/5,66,289/),float)
   u_planesb=new((/5,66,289/),float)
   w_planesb=new((/5,66,289/),float)
   
   
   do m=1,5
   
   con_planesb(m-1,:,:) =con_planes(m,:65,:)-con_planes(0,:65,:)
   u_planesb(m-1,:,:)   =u_planes(m,:65,:)-u_planes(0,:65,:)
   w_planesb(m-1,:,:)   = w_planes(m,:65,:)-w_planes(0,:65,:)
   
   plot_t(m)  = gsn_csm_contour(wks,con_planesb(m-1,:65,:),res)
   vector(m)  = gsn_csm_vector(wks,u_planesb(m-1,:65,:),w_planesb(m-1,:65,:)*100.,opts)
   overlay(plot_t(m),vector(m))
   
   end do

   


;=====================TOTAL===================
pres                  = True
pres@gsnMaximize=True

;pres@gsnPanelScalePlotIndex	= 0
;pres@gsnPanelYWhiteSpacePercent = 0
;pres@gsnPanelXWhiteSpacePercent = 0

pres@gsnPanelFigureStrings = (/"(a)","(b)","(c)","(d)","(e)","(f)"/)
pres@gsnPanelFigureStringsFontHeightF = 0.02
pres@amOrthogonalPosF    =-0.5
pres@amParallelPosF      =-0.5
pres@amJust = "TopLeft"

gsn_panel(wks,plot_t,(/2,3/),pres)
  
  
print("Game Over")
end
